// Least Mean Square adaptive equalizer
clc;
clear all;
xdel(winsid());
numPoints = 500;
numTaps = 1;		//channel order
Mu = 0.01;          //iteration step size

// input is guassian
x = rand(numPoints,1,'normal') + %i*rand(numPoints,1,'normal'); 
//choose channel to be random uniform
h = rand(numTaps,1) + %i*rand(numTaps, 1);

h = h/max(abs(h));   //normalize channel
// convolve channel with the input
d = filter(h, 1, x);

//initialize variables
w = [];
y = [];
in = []; 
e = []; // error, final result to be computed

w = zeros(numTaps+1,1) + %i*zeros(numTaps+1,1);
kk=1;
aa(kk,:)=w';
//LMS Adaptation
for n  = numTaps+1 : numPoints
    
    // select part of training input
    in = x(n : -1 : n-numTaps) ;
    y(n) =w'* in;        

    // compute error
    e(n) = d(n)-y(n);

    // update taps
       
w = w+ Mu*( real(e(n)*conj(in)) - %i*imag(e(n)*conj(in)) );

kk=kk+1;
aa(kk,:)=w';
end

// Plot results
figure;
iter=1:500
plot2d(iter,abs(e),5,logflag="nn");
title(['LMS Adaptation Learning Curve Using Mu = 0.01']);
xlabel('Iteration Number');
ylabel('Output Estimation Error in dB');
figure;
plot3d(abs(aa(:,1)),abs(aa(:,2)),abs(e));
title('LMS adaption curve with weight factors');
xlabel('adaptive weight factor1');
ylabel('adaptive weight factor2');
zlabel('mean square error');
// Output shows plot of MSE with no. of iterations in figure 1 and 3D plot of MSE with weight factors
